/* FILE: mtrigger.h                             (D. Tottingham  12/26/90)

This is an include file of defines, data structure definitions and
external declarations that are common in the mtrigger module.

*/

#ifndef _MTRIGGER_
#define _MTRIGGER_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "mqueue.h"
#include "suds.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define TRIGGER_ENABLED                 TRUE

#define EVENT_TRIGGER                   2
#define NOISE_INIT                      1

/* STA/LTA Constants */
#define LTA_INIT                        30
#define STA_SHIFT                       4
#define LTA_SHIFT                       8

/* Trigger Constants */
#define CRITICAL_ALPHA                  15
#define CRITICAL_BETA                   5
#define TRIGGER_CONFIRMATION_COUNT      30
#define CRITICAL_NU                     3
#define TRIGGER_TIME_LIMIT              15

/* Trigger states */
#define CHANNEL_TRIGGER_DISABLED        0
#define CHANNEL_TRIGGER_ENABLED         1
#define CHANNEL_TRIGGERED               2
#define CHANNEL_TRIGGERED_EVENT         3

/* Event Constants */
#define MIN_EVENT_TIME                  30
#define MAX_EVENT_TIME                  60

/* Event Energy Constants */
#define CRITICAL_GAMMA                  2
#define EVENT_CONTINUATION_COUNT        30
#define CRITICAL_MU                     3

/* Structure defines */
#define critical_alpha                  trigsetting.const1
#define critical_beta                   trigsetting.const2
#define trigger_confirmation_count      trigsetting.threshold
#define critical_nu                     trigsetting.const3
#define sta_window                      trigsetting.const4
#define lta_window                      trigsetting.wav_inc
#define trigger_time_limit              trigsetting.aperture

#define min_event_time                  eventsetting.minduration
#define max_event_time                  eventsetting.maxduration
#define critical_gamma                  eventsetting.const1
#define critical_mu                     eventsetting.const2
#define event_continuation_count        eventsetting.threshold


/************************************************************************
                          STRUCTURE DEFINITIONS


************************************************************************/
typedef struct {
        unsigned int sta_shift;
        unsigned int lta_shift;
        SUDS_STRUCTTAG structtag;
        SUDS_TRIGSETTING trigsetting;
} T_TRIGGER;

typedef struct {
        SUDS_STRUCTTAG structtag;
        SUDS_EVENTSETTING eventsetting;
} T_EVENT;


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC void t_display_event_params (FILE *);
PUBLIC void t_display_triggers (FILE *);
PUBLIC void t_display_trigger_params (FILE *);
PUBLIC FLAG t_event_done ();
PUBLIC FLAG t_event_detected();
PUBLIC unsigned int t_get_channel_trigger_state (unsigned int);
PUBLIC T_EVENT far * t_get_eventsetting ();
PUBLIC Q_CHANNEL far * t_get_head_trigger ();
PUBLIC double t_get_last_trigger ();
PUBLIC Q_CHANNEL far * t_get_next_trigger ();
PUBLIC FLAG t_get_trigger_status ();
PUBLIC double t_get_trigger_time (unsigned int);
PUBLIC T_TRIGGER far * t_get_trigsetting ();
PUBLIC FLAG t_initialize_event ();
PUBLIC FLAG t_initialize_trigger ();
PUBLIC void t_reset_event ();
PUBLIC void t_reset_trigger ();
PUBLIC void t_set_CriticalAlpha (int);
PUBLIC void t_set_CriticalBeta (int);
PUBLIC void t_set_CriticalGamma (int);
PUBLIC void t_set_CriticalMu (int);
PUBLIC void t_set_CriticalNu (int);
PUBLIC void t_set_EventContinueCount (int);
PUBLIC void t_set_event ();
PUBLIC void t_set_LTAWindow (unsigned int);
PUBLIC void t_set_MaxEventTime (double);
PUBLIC void t_set_MinEventTime (double);
PUBLIC void t_set_netwname (char *);
PUBLIC void t_set_STAWindow (unsigned int);
PUBLIC void t_set_Trigger (unsigned int, FLAG);
PUBLIC void t_set_TriggerConfirmCount (int);
PUBLIC void t_set_TriggerTimeLimit (double);
PUBLIC void t_set_trigger_status (FLAG);
PUBLIC void t_toggle_trigger_status ();
PUBLIC FLAG t_trigger_check ();

#endif
